<div class="sidebar bg--dark">
    <button class="res-sidebar-close-btn"><i class="las la-times"></i></button>
    <div class="sidebar__inner">
        <div class="sidebar__logo">
            <a class="sidebar__main-logo" href="<?php echo e(route('admin.dashboard')); ?>"><img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>"></a>
        </div>

        <div class="sidebar__menu-wrapper" id="sidebar__menuWrapper">
            <ul class="sidebar__menu">

                <?php $hasPermission = App\Models\Role::hasPermission('admin.dashboard')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.dashboard')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="menu-icon las la-home"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Dashboard'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.staff.index', 'admin.roles.index', 'admin.permissions.index'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive(['admin.staff*', 'admin.roles.*'], 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-users"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Staff'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive(['admin.staff*', 'admin.roles.*', 'admin.permissions*'], 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.staff.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.staff*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.staff.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Staff'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.roles.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.roles*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.roles.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Roles'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.users*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.users*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-users"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Users'); ?></span>

                            <?php if($bannedUsersCount > 0 || $emailUnverifiedUsersCount > 0 || $mobileUnverifiedUsersCount > 0 || $kycUnverifiedUsersCount > 0 || $kycPendingUsersCount > 0): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.users*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.active')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.active')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.active')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Active Users'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.banned')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.banned')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.banned')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Banned Users'); ?></span>
                                            <?php if($bannedUsersCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($bannedUsersCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.email.unverified')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.email.unverified')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.email.unverified')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Email Unverified'); ?></span>

                                            <?php if($emailUnverifiedUsersCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($emailUnverifiedUsersCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.mobile.unverified')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.mobile.unverified')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.mobile.unverified')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Mobile Unverified'); ?></span>
                                            <?php if($mobileUnverifiedUsersCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($mobileUnverifiedUsersCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.kyc.verified')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.kyc.verified')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.kyc.verified')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('KYC Verified'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.kyc.unverified')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.kyc.unverified')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.kyc.unverified')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('KYC Unverified'); ?></span>
                                            <?php if($kycUnverifiedUsersCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($kycUnverifiedUsersCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.kyc.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.kyc.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.kyc.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('KYC Pending'); ?></span>
                                            <?php if($kycPendingUsersCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($kycPendingUsersCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.with.balance')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.with.balance')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.with.balance')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('With Balance'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.all')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.all')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.all')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Users'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.notification.all')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.users.notification.all')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.notification.all')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Notification to All'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.deposit*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.deposit*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-file-invoice-dollar"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Deposits'); ?></span>
                            <?php if(0 < $pendingDepositsCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.deposit*', 2)); ?>">
                            <ul>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Pending Deposits'); ?></span>
                                            <?php if($pendingDepositsCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($pendingDepositsCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.approved')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.approved')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.approved')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Approved Deposits'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.successful')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.successful')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.successful')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Successful Deposits'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.rejected')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.rejected')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.rejected')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Rejected Deposits'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.initiated')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.initiated')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.initiated')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Initiated Deposits'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.deposit.list')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.list')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.list')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Deposits'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.withdraw*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.withdraw*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon la la-hand-holding-usd"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Withdrawals'); ?> </span>
                            <?php if(0 < $pendingWithdrawCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.withdraw*', 2)); ?>">
                            <ul>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.withdraw.method.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.method.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.method.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Withdrawal Methods'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.withdraw.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Pending Withdrawals'); ?></span>

                                            <?php if($pendingWithdrawCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($pendingWithdrawCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.withdraw.approved')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.approved')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.approved')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Approved Withdrawals'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.withdraw.rejected')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.rejected')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.rejected')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Rejected Withdrawals'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.withdraw.log')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.log')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.log')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Withdrawals'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.transfers*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.transfer*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-random"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Money Transfers'); ?> </span>
                            <?php if($pendingTransferCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.transfer*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Pending Transfers'); ?></span>
                                            <?php if($pendingTransferCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($pendingTransferCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.rejected')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.rejected')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.rejected')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Rejected Transfers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.own')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.own')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.own')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Own Bank Transfers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.other')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.other')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.other')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Other Bank Transfers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.wire')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.wire')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.wire')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Wire Transfers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.transfers.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.transfers.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Transfers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.bank.*')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.bank.index')); ?>">
                            <i class="menu-icon la la-bank"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Other Banks'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.wire.transfer*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.wire.transfer*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-comments-dollar"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Wire Transfer'); ?> </span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.wire.transfer*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.wire.transfer.setting')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.wire.transfer.setting')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.wire.transfer.setting')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Setting'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.wire.transfer.form')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.wire.transfer.form')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.wire.transfer.form')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Form'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.branch*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.branch*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-project-diagram"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Branches'); ?> </span>
                        </a>

                        <div class="sidebar-submenu <?php echo e(menuActive('admin.branch*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.branch.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.branch.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.branch.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Branches'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.branch.staff.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.branch.staff.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.branch.staff.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Branch Staff'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.plans*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.plans*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-chart-bar"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Plans'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.plans*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.plans.fdr.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.plans.fdr*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.plans.fdr.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('FDR Plans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.plans.dps.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.plans.dps*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.plans.dps.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('DPS Plans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.plans.loan.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.plans.loan*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.plans.loan.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Loan Plans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.fdr*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.fdr*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-money-bill"></i>
                            <span class="menu-title"><?php echo app('translator')->get('FDR'); ?> </span>
                            <?php if($dueFdrCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>

                        <div class="sidebar-submenu <?php echo e(menuActive('admin.fdr*', 2)); ?>">
                            <ul>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.running')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.fdr.running'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.fdr.running')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Running FDR'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.due')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.fdr.due')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.fdr.due')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Due FDR'); ?></span>

                                            <?php if($dueFdrCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($dueFdrCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.closed')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.fdr.closed'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.fdr.closed')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Closed FDR'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.fdr.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.fdr.index'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.fdr.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All FDR'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.dps*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.dps*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-box"></i>
                            <span class="menu-title"><?php echo app('translator')->get('DPS'); ?> </span>
                            <?php if($dueDpsCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.dps*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.dps.running')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.dps.running')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.dps.running')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Running DPS'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.dps.due')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.dps.due')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.dps.due')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Due DPS'); ?></span>
                                            <?php if($dueDpsCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e(__($dueDpsCount)); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.dps.matured')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.dps.matured'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.dps.matured')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Matured DPS'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.dps.closed')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.dps.closed'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.dps.closed')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Closed DPS'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.dps.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.dps.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.dps.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All DPS'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>


                <?php $hasPermission = App\Models\Role::hasPermission(['admin.loan*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.loan*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-hand-holding-usd"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Loans'); ?></span>
                            <?php if($pendingLoanCount || $dueLoanCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>

                        <div class="sidebar-submenu <?php echo e(menuActive('admin.loan*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Pending Loans'); ?></span>
                                            <?php if($pendingLoanCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($pendingLoanCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.running')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.running')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.running')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Running Loans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.due')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.due')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.due')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Due Loans'); ?></span>
                                            <?php if($dueLoanCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($dueLoanCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.paid')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.paid')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.paid')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Paid Loans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>


                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.rejected')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.rejected')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.rejected')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Rejected Loans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.loan.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.loan.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.loan.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Loans'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.gateway*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.gateway*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-credit-card"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Payment Gateways'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.gateway*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.gateway.automatic.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.gateway.automatic.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.gateway.automatic.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Automatic Gateways'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.gateway.manual.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.gateway.manual.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.gateway.manual.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Manual Gateways'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.ticket*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.ticket*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon la la-ticket"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Support Ticket'); ?> </span>
                            <?php if(0 < $pendingTicketCount): ?>
                                <span class="menu-badge pill bg--danger ms-auto">
                                    <i class="fa fa-exclamation"></i>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.ticket*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.ticket.pending')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.ticket.pending')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.ticket.pending')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Pending Ticket'); ?></span>
                                            <?php if($pendingTicketCount): ?>
                                                <span class="menu-badge pill bg--danger ms-auto"><?php echo e($pendingTicketCount); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.ticket.closed')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.ticket.closed')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.ticket.closed')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Closed Ticket'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.ticket.answered')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.ticket.answered')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.ticket.answered')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Answered Ticket'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.ticket.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.ticket.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.ticket.index')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('All Ticket'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.report*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.report*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon la la-list"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Report'); ?> </span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.report*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.report.transaction')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.report.transaction', 'admin.report.transaction.search'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.report.transaction')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Transaction Log'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.report.login.history')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.report.login.history', 'admin.report.login.ipHistory'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.report.login.history')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Login History'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.report.notification.history')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.report.notification.history')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.report.notification.history')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Notification History'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.subscriber.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.subscriber.*')); ?>">
                        <a class="nav-link" data-default-url="<?php echo e(route('admin.subscriber.index')); ?>" href="<?php echo e(route('admin.subscriber.index')); ?>">
                            <i class="menu-icon las la-thumbs-up"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Subscribers'); ?> </span>
                        </a>
                    </li>
                <?php endif ?>

                <?php if(can(['admin.setting.index','admin.cron.index','admin.setting.logo.icon','admin.setting.system.configuration','admin.kyc.setting','admin.referral.setting','admin.extensions.index','admin.language.manage','admin.seo','admin.setting.notification'])): ?>
                <li class="sidebar__menu-header"><?php echo app('translator')->get('Settings'); ?></li>
                <?php endif; ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.index')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.setting.index')); ?>">
                            <i class="menu-icon las la-life-ring"></i>
                            <span class="menu-title"><?php echo app('translator')->get('General Setting'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.cron.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.cron*')); ?>">
                        <a href="<?php echo e(route('admin.cron.index')); ?>" class="nav-link">
                            <i class="menu-icon las la-clock"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Cron Job Setting'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.logo.icon')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.logo.icon')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.setting.logo.icon')); ?>">
                            <i class="menu-icon las la-images"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Logo & Favicon'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.system.configuration')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.system.configuration')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.setting.system.configuration')); ?>">
                            <i class="menu-icon las la-cog"></i>
                            <span class="menu-title"><?php echo app('translator')->get('System Configuration'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.kyc.setting')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.kyc.setting')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.kyc.setting')); ?>">
                            <i class="menu-icon las la-user-check"></i>
                            <span class="menu-title"><?php echo app('translator')->get('KYC Setting'); ?></span>
                        </a>
                    </li>
                <?php endif ?>


                <?php $hasPermission = App\Models\Role::hasPermission('admin.referral.setting')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <?php if($general->modules->referral_system): ?>
                        <li class="sidebar-menu-item <?php echo e(menuActive('admin.referral.setting')); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.referral.setting')); ?>">
                                <i class="menu-icon las la-sitemap"></i>
                                <span class="menu-title"><?php echo app('translator')->get('Referral Setting'); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.extensions.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.extensions.index')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.extensions.index')); ?>">
                            <i class="menu-icon las la-cogs"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Extensions'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.language.manage')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.language.manage', 'admin.language.key'])); ?>">
                        <a class="nav-link" data-default-url="<?php echo e(route('admin.language.manage')); ?>" href="<?php echo e(route('admin.language.manage')); ?>">
                            <i class="menu-icon las la-language"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Language'); ?> </span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.seo')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.seo')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.seo')); ?>">
                            <i class="menu-icon las la-globe"></i>
                            <span class="menu-title"><?php echo app('translator')->get('SEO Manager'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission(['admin.setting.notification*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.setting.notification*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon las la-bell"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Notification Setting'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.setting.notification*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.notification.global')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.notification.global')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.setting.notification.global')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Global Template'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.notification.email')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.notification.email')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.setting.notification.email')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Email Setting'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.notification.sms')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.notification.sms')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.setting.notification.sms')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('SMS Setting'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.notification.push')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.notification.push')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.setting.notification.push')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Push Notification'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.notification.templates')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.notification.templates')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.setting.notification.templates')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Notification Templates'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php if(can(['admin.frontend.templates','admin.frontend.manage.pages','admin.frontend.sections'])): ?>
                <li class="sidebar__menu-header"><?php echo app('translator')->get('Frontend Manager'); ?></li>
                <?php endif; ?>
                <?php $hasPermission = App\Models\Role::hasPermission('admin.frontend.templates')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.frontend.templates')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.frontend.templates')); ?>">
                            <i class="menu-icon la la-puzzle-piece"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Templates'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.frontend.manage.pages')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.frontend.manage.*')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.frontend.manage.pages')); ?>">
                            <i class="menu-icon la la-list"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Pages'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.frontend.sections')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.frontend.sections*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon la la-html5"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Manage Section'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.frontend.sections*', 2)); ?>">
                            <ul>
                                <?php
                                    $lastSegment = collect(request()->segments())->last();
                                ?>
                                <?php $__currentLoopData = getPageSections(true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $secs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($secs['builder']): ?>
                                        <li class="sidebar-menu-item <?php if($lastSegment == $k): ?> active <?php endif; ?>">
                                            <a class="nav-link" href="<?php echo e(route('admin.frontend.sections', $k)); ?>">
                                                <i class="menu-icon las la-dot-circle"></i>
                                                <span class="menu-title"><?php echo e(__($secs['name'])); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php if(can(['admin.maintenance.mode','admin.setting.cookie','admin.system','admin.setting.custom.css','admin.request.report'])): ?>
                    <li class="sidebar__menu-header"><?php echo app('translator')->get('Extra'); ?></li>
                <?php endif; ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.maintenance.mode')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.maintenance.mode')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.maintenance.mode')); ?>">
                            <i class="menu-icon las la-robot"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Maintenance Mode'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.cookie')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.cookie')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.setting.cookie')); ?>">
                            <i class="menu-icon las la-cookie-bite"></i>
                            <span class="menu-title"><?php echo app('translator')->get('GDPR Cookie'); ?></span>
                        </a>
                    </li>
                <?php endif ?>


                <?php $hasPermission = App\Models\Role::hasPermission(['admin.system*'])  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a class="<?php echo e(menuActive('admin.system*', 3)); ?>" href="javascript:void(0)">
                            <i class="menu-icon la la-server"></i>
                            <span class="menu-title"><?php echo app('translator')->get('System'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.system*', 2)); ?>">
                            <ul>
                                <?php $hasPermission = App\Models\Role::hasPermission('admin.system.info')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.system.info')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.system.info')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Application'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.system.server.info')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.system.server.info')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.system.server.info')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Server'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.system.optimize')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.system.optimize')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.system.optimize')); ?>">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Cache'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                                <?php $hasPermission = App\Models\Role::hasPermission('admin.system.update')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.system.update')); ?> ">
                                        <a href="<?php echo e(route('admin.system.update')); ?>" class="nav-link">
                                            <i class="menu-icon las la-dot-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Update'); ?></span>
                                        </a>
                                    </li>
                                <?php endif ?>

                            </ul>
                        </div>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.custom.css')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.setting.custom.css')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.setting.custom.css')); ?>">
                            <i class="menu-icon lab la-css3-alt"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Custom CSS'); ?></span>
                        </a>
                    </li>
                <?php endif ?>

                <?php $hasPermission = App\Models\Role::hasPermission('admin.request.report')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.request.report')); ?>">
                        <a class="nav-link" data-default-url="<?php echo e(route('admin.request.report')); ?>" href="<?php echo e(route('admin.request.report')); ?>">
                            <i class="menu-icon las la-bug"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Report & Request'); ?> </span>
                        </a>
                    </li>
                <?php endif ?>

            </ul>
            <div class="text-uppercase mb-3 text-center">
                <span class="text--primary"><?php echo e(__(systemDetails()['name'])); ?></span>
                <span class="text--success"><?php echo app('translator')->get('V'); ?><?php echo e(systemDetails()['version']); ?> </span>
            </div>
        </div>
    </div>
</div>
<!-- sidebar end -->

<?php $__env->startPush('script'); ?>
    <script>
        if ($('li').hasClass('active')) {
            $('#sidebar__menuWrapper').animate({
                scrollTop: eval($(".active").offset().top - 320)
            }, 500);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\sorrowbank\core\resources\views/admin/partials/sidenav.blade.php ENDPATH**/ ?>