<?php $__env->startSection('panel'); ?>
    <form method="POST">
        <?php echo csrf_field(); ?>
        <div class="row gy-4">
            <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo app('translator')->get('Transfer Limit'); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Minimum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="minimum_limit" value="<?php echo e(old('minimum_limit', @$setting->minimum_limit)); ?>" required>
                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="maximum_limit" value="<?php echo e(old('maximum_limit', @$setting->maximum_limit)); ?>" required>
                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo app('translator')->get('Tranfer Charge'); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Fixed'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="fixed_charge" value="<?php echo e(old('fixed_charge', @$setting->fixed_charge)); ?>" required>
                                        <div class="input-group-text"><?php echo e(__($general->cur_text)); ?></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Percent'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="percent_charge" value="<?php echo e(old('percent_charge', @$setting->percent_charge)); ?>" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo app('translator')->get('Daily Limit'); ?></h6>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="daily_maximum_limit" value="<?php echo e(old('daily_maximum_limit', @$setting->daily_maximum_limit)); ?>" required>
                                        <div class="input-group-text"><?php echo e(__($general->cur_text)); ?></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Count'); ?></label>
                                    <input type="number" class="form-control" name="daily_total_transaction" value="<?php echo e(old('daily_total_transaction', @$setting->daily_total_transaction)); ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo app('translator')->get('Monthly Limit'); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="monthly_maximum_limit" value="<?php echo e(old('monthly_maximum_limit', @$setting->monthly_maximum_limit)); ?>" required>
                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Count'); ?></label>
                                    <input type="number" class="form-control" name="monthly_total_transaction" value="<?php echo e(old('monthly_total_transaction', @$setting->monthly_total_transaction)); ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo app('translator')->get('Instruction'); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <textarea rows="8" class="form-control nicEdit" name="instruction">
                                <?php echo old('instruction', @$setting->instruction); ?>
                            </textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php $hasPermission = App\Models\Role::hasPermission('admin.wire.transfer.setting.save')  ? 1 : 0;
            if($hasPermission == 1): ?>
            <button class="btn btn--primary w-100 h-45 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
        <?php endif ?>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/admin/wire_transfer/setting.blade.php ENDPATH**/ ?>