<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('TRX No.'); ?> | <?php echo app('translator')->get('Bank'); ?></th>
                                    <th><?php echo app('translator')->get('Sender'); ?></th>
                                    <th><?php echo app('translator')->get('Receiver'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?> | <?php echo app('translator')->get('Charge'); ?></th>
                                    <th><?php echo app('translator')->get('Final Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Staus'); ?></th>
                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.details')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif ?>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->index + $transfers->firstItem()); ?></td>

                                        <td>
                                            <span><?php echo e($transfer->trx); ?></span>
                                            <br>
                                            <?php if($transfer->beneficiary): ?>
                                                <span class="text--info">
                                                    <?php echo e($transfer->beneficiary->beneficiaryOf->name ?? $general->site_name); ?>

                                                </span>
                                            <?php else: ?>
                                                <span class="text--warning fw-bold"><?php echo app('translator')->get('Wire Transfer'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <span class="d-block"><?php echo e(__($transfer->user->account_number)); ?></span>
                                            <?php $hasPermission = App\Models\Role::hasPermission('admin.users.detail')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                <a href="<?php echo e(route('admin.users.detail', $transfer->user_id)); ?>">
                                                    <span>@</span><?php echo e(__($transfer->user->username)); ?>

                                                </a>
                                            <?php else: ?>
                                                <span>@</span><?php echo e(__($transfer->user->username)); ?>

                                            <?php endif ?>
                                        </td>

                                        <td>
                                            <?php if($transfer->beneficiary): ?>
                                                <span class="d-block"><?php echo e(__(@$transfer->beneficiary->account_number)); ?></span>
                                                <?php $hasPermission = App\Models\Role::hasPermission('admin.users.detail')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                    <a href="<?php echo e(route('admin.users.detail', $transfer->user_id)); ?>">
                                                        <span>@</span><?php echo e(__(@$transfer->beneficiary->user->username)); ?>

                                                    </a>
                                                <?php else: ?>
                                                    <span>@</span><?php echo e(__(@$transfer->beneficiary->user->username)); ?>

                                                <?php endif ?>
                                            <?php else: ?>
                                                <?php echo e($transfer->wireTransferAccountNumber()); ?>

                                                <br>
                                                <span class="text--base fw-bold"><?php echo e($transfer->wireTransferAccountName()); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <span class="fw-bold"><?php echo e(__($general->cur_sym . showAmount($transfer->amount))); ?></span>
                                            <span class="small d-block">
                                                <span class="text--danger fw-bold"><?php echo e(__($general->cur_sym . showAmount($transfer->charge))); ?></span>
                                            </span>
                                        </td>

                                        <td>
                                            <span class="fw-bold"> <?php echo e(__($general->cur_sym . showAmount($transfer->final_amount))); ?></span>
                                        </td>

                                        <td><?php echo $transfer->status_badge ?></td>

                                        <?php $hasPermission = App\Models\Role::hasPermission('admin.transfers.details')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                            <td>
                                                <a class="btn btn-sm btn-outline--primary" href="<?php echo e(route('admin.transfers.details', $transfer->id)); ?>">
                                                    <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                                </a>
                                            </td>
                                        <?php endif ?>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($transfers->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($transfers)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'TRX No.']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'TRX No.']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sorrowbank\core\resources\views/admin/transfers/index.blade.php ENDPATH**/ ?>