<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <?php if($general->modules->own_bank && $general->modules->other_bank): ?>
                    <div class="d-flex flex-wrap gap-2 mb-3">

                        <?php if($general->modules->own_bank): ?>
                            <a href="<?php echo e(route('user.beneficiary.own')); ?>" class="btn btn-md btn--dark"><?php echo app('translator')->get($general->site_name); ?></a>
                        <?php endif; ?>

                        <?php if($general->modules->other_bank): ?>
                            <a href="javascript:void(0)" class="btn btn-md btn--base"><?php echo app('translator')->get('Other Banks'); ?></a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="card custom--card mb-4 <?php if(!old('account_number') || !old('id')): ?> d-none <?php endif; ?>" id="addForm">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="card-title"><?php echo app('translator')->get('Add Beneficiary to Other Banks'); ?></h5>

                            <button class="btn btn-sm btn--danger close-form" type="button"><i
                                    class="la la-times"></i></button>
                        </div>
                    </div>

                    <div class="card-body p-4">
                        <form action="<?php echo e(route('user.beneficiary.other.add')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Select Bank'); ?></label>
                                <select class="form--control" name="bank" required>
                                    <option value="" disabled selected><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $otherBanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Short Name'); ?></label>
                                <input class="form--control" name="short_name" type="text" required>
                            </div>
                            <div id="user-fields">
                            </div>
                            <button class="btn w-100 btn--base" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                    </div>
                </div>

                <div class="table-responsive--md">
                    <div class="text-end">
                        <button class="btn btn-sm btn--dark add-btn mb-3" type="button"><i class="la la-plus-circle"></i>
                            <?php echo app('translator')->get('Add Beneficiary'); ?></button>
                    </div>

                    <table class="custom--table table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Bank'); ?></th>
                                <th><?php echo app('translator')->get('Account No.'); ?></th>
                                <th><?php echo app('translator')->get('Account Name'); ?></th>
                                <th><?php echo app('translator')->get('Short Name'); ?></th>
                                <th><?php echo app('translator')->get('Details'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($beneficiary->beneficiaryOf->name); ?></td>
                                    <td><?php echo e($beneficiary->account_number); ?></td>
                                    <td><?php echo e($beneficiary->account_name); ?></td>
                                    <td><?php echo e($beneficiary->short_name); ?></td>
                                    <td>
                                        <div class="button-group">
                                            <button class="btn btn-sm btn--primary seeDetails"
                                                data-id="<?php echo e($beneficiary->id); ?>"><i class="la la-desktop"></i></button>
                                            <button class="btn btn-sm btn--base EditBeneficiary"
                                                data-resources="<?php echo e($beneficiary); ?>"><i class="la la-pen"></i></button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($beneficiaries->hasPages()): ?>
                    <?php echo e(paginateLinks($beneficiaries)); ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="detailsModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Benficiary Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ajax-loader','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ajax-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            const addForm = $('#addForm');

            $('.add-btn').on('click', function() {
                $(this).parent().hide();
                addForm.find('.card-title').text(`<?php echo app('translator')->get('Add Beneficiary to Other Banks'); ?>`);
                addForm.find('form').trigger("reset");
                $('input:radio').removeAttr('checked');
                addForm.removeClass('d-none').hide().fadeIn(500);
            });

            $('.close-form').on('click', function() {
                $('.add-btn').parent().fadeIn(500);
                addForm.addClass('d-none');
                $('.add-btn').removeClass('d-none').hide().fadeIn(500);
            });

            addForm.find('select[name=bank]').on('change', function() {
                let bankId = $(this).val();
                bankFormProcess(bankId)
            });


            $('.seeDetails').on('click', function() {
                let modal = $('#detailsModal');
                modal.find('.loading').removeClass('d-none');
                let action = `<?php echo e(route('user.beneficiary.details', ':id')); ?>`;
                let id = $(this).attr('data-id');
                $.ajax({
                    url: action.replace(':id', id),
                    type: "GET",
                    dataType: 'json',
                    cache: false,
                    success: function(response) {
                        if (response.success) {
                            modal.find('.loading').addClass('d-none');
                            modal.find('.modal-body').html(response.html);
                            modal.modal('show');
                        } else {
                            notify('error', response.message || `<?php echo app('translator')->get('Something went the wrong'); ?>`)
                        }
                    },
                    error: function(e) {
                        notify(`<?php echo app('translator')->get('Something went the wrong'); ?>`)
                    }
                });
            });

            function bankFormProcess(bankId) {
                let action = `<?php echo e(route('user.beneficiary.other.bank.form.data', ':id')); ?>`;
                $.ajax({
                    url: action.replace(':id', bankId),
                    type: "GET",
                    dataType: 'json',
                    cache: false,
                    success: function(response) {
                        if (response.success) {
                            $('#user-fields').html(response.html).hide().fadeIn(500);
                        } else {
                            notify('error', response.message || `<?php echo app('translator')->get('Something went the wrong'); ?>`)
                        }
                    },
                    error: function(e) {
                        notify(`<?php echo app('translator')->get('Something went the wrong'); ?>`)
                    }
                });
            }

            $('.EditBeneficiary').on('click', function() {

                let beneficiary = $(this).data('resources');
                let bankId = beneficiary.beneficiary_of.id;
                bankFormProcess(bankId);
                setTimeout(() => {
                    addForm.find('.card-title').text(`<?php echo app('translator')->get('Update Beneficiary to Other Banks'); ?>`);
                    addForm.find('[name=id]').val(beneficiary.id);
                    addForm.find('[name=bank]').val(bankId);
                    addForm.find('input[name="short_name"]').val(beneficiary.short_name);
                    addForm.find('input[name="account_number"]').val(beneficiary.account_number);
                    addForm.find('input[name="account_name"]').val(beneficiary.account_name);

                    if (beneficiary.details.length > 0) {
                        let details = beneficiary.details.slice(2);

                        $.each(beneficiary.details, function(index, value) {
                            var lowerName = value.name.replace(/\s+/g, '_').toLowerCase();
                            if (value.type == 'radio') {
                                addForm.find('input:radio[name="' + lowerName + '"]').filter(
                                    '[value="' + value.value + '"]').attr('checked', true);
                            } else if (value.type == 'textarea') {
                                addForm.find('textarea[name="' + lowerName + '"]').text(value
                                    .value);
                            } else if (value.type == 'select') {
                                addForm.find('select[name="' + lowerName + '"]').val(value
                                    .value);
                            } else if (value.type == 'file') {
                                addForm.find('input[name="' + lowerName + '"]').val('');
                            } else {
                                addForm.find('input[name="' + lowerName + '"]').val(value
                                    .value);
                            }
                        });
                    }
                    addForm.removeClass('d-none');
                }, 500);
                $('.add-btn').addClass('d-none').hide().fadeIn(500);
            });


        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transfer-bottom-menu','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('transfer-bottom-menu'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/transfer/beneficiary/other.blade.php ENDPATH**/ ?>